/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher.mutli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.runelite.launcher.ColorScheme;
import net.runelite.launcher.LauncherProperties;
import net.runelite.launcher.SplashScreen;
import net.runelite.launcher.mutli.FontManager;
import net.runelite.launcher.mutli.InfoPanel;
import net.runelite.launcher.mutli.MessagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreenMultipleOptions
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(SplashScreenMultipleOptions.class);
    private static SplashScreenMultipleOptions INSTANCE;
    static final Dimension FRAME_SIZE;
    private MessagePanel messagePanel;

    private SplashScreenMultipleOptions(List<JButton> buttons) {
        this.setTitle(LauncherProperties.getApplicationName());
        this.setDefaultCloseOperation(2);
        this.setSize(FRAME_SIZE);
        this.setLayout(new BorderLayout());
        this.setUndecorated(true);
        try {
            this.setIconImage(ImageIO.read(SplashScreen.class.getResourceAsStream("runelite.png")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(FRAME_SIZE);
        this.messagePanel = new MessagePanel(buttons);
        panel.add((Component)new InfoPanel("d"), "East");
        panel.add((Component)this.messagePanel, "West");
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setBarText(String text) {
        JProgressBar bar = this.messagePanel.getBar();
        bar.setString(text);
        bar.setStringPainted(text != null);
        bar.revalidate();
        bar.repaint();
    }

    private void setMessage(String msg, double value) {
        this.messagePanel.getBarLabel().setText(msg);
        this.messagePanel.getBar().setMaximum(1000);
        this.messagePanel.getBar().setValue((int)(value * 1000.0));
        this.setBarText(null);
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    public static void init(List<JButton> buttons) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (INSTANCE != null) {
                    return;
                }
                try {
                    INSTANCE = new SplashScreenMultipleOptions(buttons);
                }
                catch (Exception e) {
                    log.warn("Unable to start splash screen", e);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException bs) {
            throw new RuntimeException(bs);
        }
    }

    public static void close() {
        SwingUtilities.invokeLater(() -> {
            if (INSTANCE == null) {
                return;
            }
            INSTANCE.setDefaultCloseOperation(0);
            INSTANCE.setVisible(false);
            INSTANCE.dispose();
            INSTANCE = null;
        });
    }

    public static void stage(double startProgress, double endProgress, String progressText, int done, int total) {
        String progress = done + " / " + total;
        SplashScreenMultipleOptions.stage(startProgress + (endProgress - startProgress) * (double)done / (double)total, progressText + " " + progress);
    }

    public static void stage(double startProgress, double endProgress, String progressText, int done, int total, boolean mib) {
        Object progress;
        if (mib) {
            double Mb = 1000000.0;
            progress = String.format("%.1f / %.1f MB", (double)done / 1000000.0, (double)total / 1000000.0);
        } else {
            progress = done + " / " + total;
        }
        SplashScreenMultipleOptions.stage(startProgress + (endProgress - startProgress) * (double)done / (double)total, progressText + " " + (String)progress);
    }

    public static void stage(double overallProgress, String progressText) {
        if (INSTANCE != null) {
            INSTANCE.setMessage(progressText, overallProgress);
        }
    }

    public static void barMessage(String barMessage) {
        if (INSTANCE != null) {
            INSTANCE.setMessage(barMessage, 0.0);
        }
    }

    public static void message(String message) {
        if (INSTANCE != null) {
            SplashScreenMultipleOptions.INSTANCE.messagePanel.setMessageContent(message);
        }
    }

    public static JButton addButton(String action, String tooltip) {
        JButton btn = new JButton(action);
        btn.setToolTipText(tooltip);
        btn.setPreferredSize(new Dimension(40, 40));
        btn.setFont(new Font(FontManager.getRunescapeFont().getName(), FontManager.getRunescapeSmallFont().getStyle(), 16));
        btn.setForeground(Color.WHITE);
        btn.setOpaque(false);
        btn.setContentAreaFilled(false);
        btn.setFocusPainted(false);
        btn.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR));
        btn.setCursor(Cursor.getPredefinedCursor(12));
        return btn;
    }

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    static {
        FRAME_SIZE = new Dimension(600, 350);
    }
}

