/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher.mutli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;
import net.runelite.launcher.ColorScheme;
import net.runelite.launcher.LauncherProperties;
import net.runelite.launcher.mutli.CustomScrollBarUI;
import net.runelite.launcher.mutli.FontManager;
import net.runelite.launcher.mutli.InfoPanel;
import net.runelite.launcher.mutli.SplashScreenMultipleOptions;

class MessagePanel
extends JPanel {
    private static final Dimension PANEL_SIZE = new Dimension(SplashScreenMultipleOptions.FRAME_SIZE.width - InfoPanel.PANEL_SIZE.width, SplashScreenMultipleOptions.FRAME_SIZE.height);
    private static final Dimension BAR_SIZE = new Dimension(MessagePanel.PANEL_SIZE.width, 30);
    private static final int MESSAGE_AREA_PADDING = 15;
    private final JLabel titleLabel = new JLabel("Welcome to");
    private final JLabel messageArea;
    private final JLabel bootstrapChannel;
    private final JLabel barLabel = new JLabel("Doing something important");
    private final JProgressBar bar = new JProgressBar(0, 100);
    private final JScrollPane scrollPane;
    private final JPanel buttonPanel;
    private final List<JButton> buttons = new ArrayList<JButton>();

    MessagePanel(List<JButton> buttons) {
        this.setPreferredSize(PANEL_SIZE);
        this.setLayout(new GridBagLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 25;
        this.titleLabel.setText("Welcome to " + LauncherProperties.getApplicationName());
        this.titleLabel.setFont(new Font(FontManager.getRunescapeFont().getName(), FontManager.getRunescapeFont().getStyle(), 32));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setForeground(Color.WHITE);
        this.add((Component)this.titleLabel, c);
        ++c.gridy;
        this.messageArea = this.messageArea("Open-source client for Old School RuneScape with more functionality and fewer restrictions.");
        this.scrollPane = new JScrollPane(this.messageArea, 20, 31);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollPane.getVerticalScrollBar().setUI(new CustomScrollBarUI());
        JViewport scrollPaneViewport = this.scrollPane.getViewport();
        scrollPaneViewport.setForeground(Color.WHITE);
        scrollPaneViewport.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        scrollPaneViewport.setOpaque(true);
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.scrollPane, c);
        ++c.gridy;
        this.bootstrapChannel = this.messageArea("Please Select the Client you wish to run, any beta or alpha clients may be unstable due to expermental code. Thanks.");
        this.add((Component)this.bootstrapChannel, c);
        ++c.gridy;
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.buttonPanel.setBorder(new EmptyBorder(50, 10, 50, 10));
        this.buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.buttonPanel.setOpaque(true);
        buttons.forEach(this.buttonPanel::add);
        this.add((Component)this.buttonPanel, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.ipady = 5;
        this.barLabel.setFont(FontManager.getRunescapeFont());
        this.barLabel.setHorizontalAlignment(0);
        this.barLabel.setForeground(Color.WHITE);
        this.barLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.add((Component)this.barLabel, c);
        ++c.gridy;
        this.bar.setFont(FontManager.getRunescapeFont());
        this.bar.setBackground(ColorScheme.BRAND_TRANSPARENT.darker());
        this.bar.setForeground(ColorScheme.BRAND);
        this.bar.setMinimumSize(BAR_SIZE);
        this.bar.setMaximumSize(BAR_SIZE);
        this.bar.setBorder(new MatteBorder(0, 0, 0, 0, Color.LIGHT_GRAY));
        this.bar.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionBackground() {
                return ColorScheme.DARKER_GRAY_COLOR;
            }

            @Override
            protected Color getSelectionForeground() {
                return ColorScheme.DARKER_GRAY_COLOR;
            }
        });
        this.bar.setFont(FontManager.getRunescapeFont());
        this.bar.setVisible(true);
        this.add((Component)this.bar, c);
        ++c.gridy;
    }

    private JLabel messageArea(String message) {
        JLabel messageArea = new JLabel("<html><div style='text-align:center;'>" + message + "</div></html>"){

            @Override
            public Dimension getPreferredSize() {
                Dimension results = super.getPreferredSize();
                results.width = MessagePanel.PANEL_SIZE.width - 15;
                return results;
            }
        };
        messageArea.setFont(new Font(FontManager.getRunescapeFont().getName(), FontManager.getRunescapeSmallFont().getStyle(), 16));
        messageArea.setForeground(Color.WHITE);
        messageArea.setBorder(new EmptyBorder(0, 15, 0, 15));
        return messageArea;
    }

    void setMessageContent(String content) {
        if (content != null && !((String)content).startsWith("<html")) {
            content = "<html><div style='text-align:center;'>" + (String)content + "</div></html>";
        }
        this.messageArea.setText((String)content);
        this.messageArea.revalidate();
        this.messageArea.repaint();
    }

    void setMessageTitle(String text) {
        this.titleLabel.setText(text);
        this.titleLabel.revalidate();
        this.titleLabel.repaint();
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JLabel getMessageArea() {
        return this.messageArea;
    }

    public JLabel getBootstrapChannel() {
        return this.bootstrapChannel;
    }

    public JLabel getBarLabel() {
        return this.barLabel;
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public List<JButton> getButtons() {
        return this.buttons;
    }
}

