/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher.mutli;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import javax.swing.text.StyleContext;
import net.runelite.launcher.Launcher;

public class FontManager {
    private static Font runescapeFont;
    private static Font runescapeSmallFont;

    public static void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Font font = Font.createFont(0, Launcher.class.getResourceAsStream("runescape.ttf")).deriveFont(0, 16.0f);
            ge.registerFont(font);
            runescapeFont = StyleContext.getDefaultStyleContext().getFont(font.getName(), 0, 16);
            ge.registerFont(runescapeFont);
            Font smallFont = Font.createFont(0, Launcher.class.getResourceAsStream("runescape_small.ttf")).deriveFont(0, 16.0f);
            ge.registerFont(smallFont);
            runescapeSmallFont = StyleContext.getDefaultStyleContext().getFont(smallFont.getName(), 0, 16);
            ge.registerFont(runescapeSmallFont);
        }
        catch (FontFormatException ex) {
            throw new RuntimeException("Font loaded, but format incorrect.", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Font file not found.", ex);
        }
    }

    static Font getRunescapeFont() {
        return runescapeFont;
    }

    static Font getRunescapeSmallFont() {
        return runescapeSmallFont;
    }
}

