/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.archivepatcher.applier.FileByFileV1DeltaApplier;
import com.google.archivepatcher.shared.DefaultDeflateCompatibilityWindow;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.runelite.launcher.CertPathExtractor;
import net.runelite.launcher.ConfigurationFrame;
import net.runelite.launcher.FatalErrorDialog;
import net.runelite.launcher.ForkLauncher;
import net.runelite.launcher.HardwareAccelerationMode;
import net.runelite.launcher.JvmLauncher;
import net.runelite.launcher.LaunchMode;
import net.runelite.launcher.LauncherProperties;
import net.runelite.launcher.LauncherSettings;
import net.runelite.launcher.LinkBrowser;
import net.runelite.launcher.OS;
import net.runelite.launcher.PackrConfig;
import net.runelite.launcher.ReflectionLauncher;
import net.runelite.launcher.SplashScreen;
import net.runelite.launcher.TrustManagerUtil;
import net.runelite.launcher.Updater;
import net.runelite.launcher.VerificationException;
import net.runelite.launcher.beans.Artifact;
import net.runelite.launcher.beans.Bootstrap;
import net.runelite.launcher.beans.ClientType;
import net.runelite.launcher.beans.Diff;
import net.runelite.launcher.beans.Platform;
import net.runelite.launcher.mutli.FontManager;
import net.runelite.launcher.mutli.SplashScreenMultipleOptions;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Launcher.class);
    private static final File RUNELITE_DIR = new File(System.getProperty("user.home"), "." + LauncherProperties.getApplicationName());
    public static final File LOGS_DIR = new File(RUNELITE_DIR, "logs");
    public static final File CRASH_FILES = new File(LOGS_DIR, "jvm_crash_pid_%p.log");
    private static final String USER_AGENT = LauncherProperties.getApplicationName() + "/" + LauncherProperties.getVersion();
    static final String LAUNCHER_EXECUTABLE_NAME_WIN = LauncherProperties.getApplicationName() + ".exe";
    static final String LAUNCHER_EXECUTABLE_NAME_OSX = LauncherProperties.getApplicationName();
    static HashMap<String, ClientType> clientTypes = new HashMap();
    public static boolean displayMultipleOptions = false;

    public static void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts("postinstall", "Perform post-install tasks");
        parser.accepts("debug", "Enable debug logging");
        parser.accepts("nodiff", "Always download full artifacts instead of diffs");
        parser.accepts("insecure-skip-tls-verification", "Disable TLS certificate and hostname verification");
        parser.accepts("scale", "Custom scale factor for Java 2D").withRequiredArg();
        parser.accepts("noupdate", "Skips the launcher self-update");
        parser.accepts("help", "Show this text (use --clientargs --help for client help)").forHelp();
        parser.accepts("classpath", "Classpath for the client").withRequiredArg();
        parser.accepts("J", "JVM argument (FORK or JVM launch mode only)").withRequiredArg();
        parser.accepts("configure", "Opens configuration GUI");
        parser.accepts("launch-mode", "JVM launch method (JVM, FORK, REFLECT)").withRequiredArg().ofType(LaunchMode.class);
        parser.accepts("hw-accel", "Java 2D hardware acceleration mode (OFF, DIRECTDRAW, OPENGL, METAL)").withRequiredArg().ofType(HardwareAccelerationMode.class);
        parser.accepts("mode", "Alias of hw-accel").withRequiredArg().ofType(HardwareAccelerationMode.class);
        if (OS.getOs() == OS.OSType.MacOS) {
            parser.accepts("p").withRequiredArg();
        }
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            log.error("unable to parse arguments", ex);
            SwingUtilities.invokeLater(() -> new FatalErrorDialog("{name} was unable to parse the provided application arguments: " + ex.getMessage()).open());
            throw ex;
        }
        if (options.has("help")) {
            try {
                parser.printHelpOn(System.out);
            }
            catch (IOException e2) {
                log.error(null, e2);
            }
            System.exit(0);
        }
        if (options.has("configure")) {
            ConfigurationFrame.open();
            return;
        }
        LauncherSettings settings = LauncherSettings.loadSettings();
        settings.apply(options);
        boolean postInstall = options.has("postinstall");
        LOGS_DIR.mkdirs();
        if (settings.isDebug()) {
            Logger logger = (Logger)LoggerFactory.getLogger("ROOT");
            logger.setLevel(Level.DEBUG);
        }
        Launcher.retrieveClientTypes();
        Launcher.initDll();
        Launcher.initDllBlacklist();
        try {
            if (options.has("classpath")) {
                TrustManagerUtil.setupTrustManager();
                String clientName = ((ClientType)((Map.Entry)clientTypes.entrySet().stream().findAny().get()).getValue()).getName();
                File location = new File(RUNELITE_DIR, "repository/" + clientName + "/");
                String classpathOpt = String.valueOf(options.valueOf("classpath"));
                List<File> classpath = Streams.stream(Splitter.on(File.pathSeparatorChar).split(classpathOpt)).map(name -> new File(location, (String)name)).collect(Collectors.toList());
                try {
                    ReflectionLauncher.launch(classpath, Launcher.getClientArgs(settings), ((ClientType)((Map.Entry)clientTypes.entrySet().stream().findAny().get()).getValue()).getName());
                }
                catch (Exception e3) {
                    log.error("error launching client", e3);
                }
                return;
            }
            LinkedHashMap<String, String> jvmProps = new LinkedHashMap<String, String>();
            if (settings.scale != null) {
                jvmProps.put("sun.java2d.dpiaware", "true");
                jvmProps.put("sun.java2d.uiScale", Double.toString(settings.scale));
            }
            HardwareAccelerationMode hardwareAccelMode = settings.hardwareAccelerationMode == HardwareAccelerationMode.AUTO ? HardwareAccelerationMode.defaultMode(OS.getOs()) : settings.hardwareAccelerationMode;
            jvmProps.putAll(hardwareAccelMode.toParams(OS.getOs()));
            if (OS.getOs() == OS.OSType.MacOS) {
                jvmProps.put("apple.awt.application.appearance", "system");
            }
            jvmProps.put(LauncherProperties.getVersionKey(), LauncherProperties.getVersion());
            if (settings.isSkipTlsVerification()) {
                jvmProps.put("runelite.insecure-skip-tls-verification", "true");
            }
            log.info(LauncherProperties.getApplicationName() + " Launcher version {}", (Object)LauncherProperties.getVersion());
            log.info("Launcher configuration:" + System.lineSeparator() + "{}", (Object)settings.configurationStr());
            log.info("Using hardware acceleration mode: {}", (Object)hardwareAccelMode);
            Launcher.setJvmParams(jvmProps);
            if (settings.isSkipTlsVerification()) {
                TrustManagerUtil.setupInsecureTrustManager();
            } else {
                TrustManagerUtil.setupTrustManager();
            }
            if (displayMultipleOptions) {
                FontManager.init();
                ArrayList<JButton> buttons = new ArrayList<JButton>();
                for (Map.Entry<String, ClientType> type : clientTypes.entrySet()) {
                    JButton button = SplashScreenMultipleOptions.addButton(Launcher.toTitleCase(type.getKey()), type.getValue().getTooltip());
                    button.addActionListener(e -> {
                        Runnable task = () -> Launcher.launch(Launcher.toTitleCase((String)type.getKey()), args, settings, jvmProps, postInstall);
                        Thread thread = new Thread(task);
                        thread.start();
                    });
                    buttons.add(button);
                }
                SplashScreenMultipleOptions.init(buttons);
                SplashScreenMultipleOptions.barMessage(null);
                SplashScreenMultipleOptions.message(null);
            } else {
                SplashScreen.init();
                Runnable task = () -> Launcher.launch(Launcher.toTitleCase(((ClientType)((Map.Entry)clientTypes.entrySet().stream().findAny().get()).getValue()).getName()), args, settings, jvmProps, postInstall);
                Thread thread = new Thread(task);
                thread.start();
            }
        }
        catch (Exception e4) {
            log.error("Failure during startup", e4);
            if (!postInstall) {
                SwingUtilities.invokeLater(() -> new FatalErrorDialog("{name} has encountered an unexpected error during startup.").open());
            }
        }
        catch (Error e5) {
            log.error("Failure during startup", e5);
            throw e5;
        }
    }

    public static void launch(String type, String[] args, LauncherSettings settings, Map<String, String> jvmProps, boolean postInstall) {
        try {
            Bootstrap bootstrap;
            if (postInstall) {
                Launcher.postInstall(type);
                return;
            }
            File location = new File(RUNELITE_DIR, "repository/" + type + "/");
            Launcher.stage(0.0, "Preparing", "Setting up environment");
            if (log.isDebugEnabled()) {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                log.debug("Command line arguments: {}", (Object)String.join((CharSequence)" ", args));
                log.debug("Java VM arguments: {}", (Object)String.join((CharSequence)" ", runtime.getInputArguments()));
                log.debug("Java Environment:");
                Properties p = System.getProperties();
                Enumeration<Object> keys = p.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)p.get(key);
                    log.debug("  {}: {}", (Object)key, (Object)value);
                }
            }
            Launcher.stage(0.05, null, "Downloading bootstrap");
            try {
                bootstrap = Launcher.getBootstrap(type);
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | VerificationException ex) {
                log.error("error fetching bootstrap", ex);
                String extract = CertPathExtractor.extract(ex);
                if (extract != null) {
                    log.error("untrusted certificate chain: {}", (Object)extract);
                }
                SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("downloading the bootstrap", ex));
                Launcher.close();
                return;
            }
            Launcher.stage(0.07, null, "Checking for updates");
            Updater.update(bootstrap, settings, args);
            Launcher.stage(0.1, null, "Tidying the cache");
            if (Launcher.jvmOutdated(bootstrap)) {
                return;
            }
            PackrConfig.updateLauncherArgs(bootstrap);
            if (!location.exists() && !location.mkdirs()) {
                log.error("unable to create repo directory {}", (Object)location);
                SwingUtilities.invokeLater(() -> new FatalErrorDialog("Unable to create {name} directory " + location.getAbsolutePath() + ". Check your filesystem permissions are correct.").open());
                return;
            }
            List<Artifact> artifacts = Arrays.stream(bootstrap.getArtifacts()).filter(a -> {
                if (a.getPlatform() == null) {
                    return true;
                }
                String os = System.getProperty("os.name");
                String arch = System.getProperty("os.arch");
                for (Platform platform : a.getPlatform()) {
                    OS.OSType platformOs;
                    if (platform.getName() == null || !((platformOs = OS.parseOs(platform.getName())) == OS.OSType.Other ? platform.getName().equals(os) : platformOs == OS.getOs()) || platform.getArch() != null && !platform.getArch().equals(arch)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            Launcher.clean(artifacts, type);
            try {
                Launcher.download(artifacts, settings.isNodiffs(), type);
            }
            catch (IOException ex) {
                log.error("unable to download artifacts", ex);
                SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("downloading the client", ex));
                Launcher.close();
                return;
            }
            Launcher.stage(0.8, null, "Verifying");
            try {
                Launcher.verifyJarHashes(artifacts, type);
            }
            catch (VerificationException ex) {
                log.error("Unable to verify artifacts", ex);
                SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("verifying downloaded files", ex));
                Launcher.close();
                return;
            }
            Collection<String> clientArgs = Launcher.getClientArgs(settings);
            Launcher.stage(0.9, "Starting the client", "");
            List<File> classpath = artifacts.stream().map(dep -> new File(location, dep.getName())).collect(Collectors.toList());
            ArrayList<String> jvmParams = new ArrayList<String>();
            log.debug("Setting JVM crash log location to {}", (Object)CRASH_FILES);
            jvmParams.add("-XX:ErrorFile=" + CRASH_FILES.getAbsolutePath());
            jvmParams.addAll(Launcher.getJvmArgs(settings));
            if (settings.launchMode == LaunchMode.REFLECT) {
                log.debug("Using launch mode: REFLECT");
                ReflectionLauncher.launch(classpath, clientArgs, "");
            } else if (settings.launchMode == LaunchMode.FORK || settings.launchMode == LaunchMode.AUTO && ForkLauncher.canForkLaunch()) {
                log.debug("Using launch mode: FORK");
                ForkLauncher.launch(bootstrap, classpath, clientArgs, jvmProps, jvmParams);
            } else {
                log.debug("Using launch mode: JVM");
                JvmLauncher.launch(bootstrap, classpath, clientArgs, jvmProps, jvmParams, type);
            }
        }
        catch (Exception e) {
            log.error("Failure during startup", e);
            if (!postInstall) {
                SwingUtilities.invokeLater(() -> new FatalErrorDialog("{name} has encountered an unexpected error during startup.").open());
            }
        }
        catch (Error e) {
            log.error("Failure during startup", e);
            throw e;
        }
        finally {
            Launcher.close();
        }
    }

    private static void setJvmParams(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static String toTitleCase(String givenString) {
        String[] arr = givenString.split(" ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static void retrieveClientTypes() {
        try {
            ClientType[] types;
            for (ClientType type : types = Launcher.getClientManifest()) {
                clientTypes.put(type.getName(), type);
            }
        }
        catch (Exception ex) {
            log.error("error fetching client types", ex);
            SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("No Clients Found", new Exception("No Clients Found")));
        }
        if (clientTypes.size() == 0) {
            log.error("No Clients Found");
            SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("No Clients Found", new Exception("No Clients Found")));
        } else {
            displayMultipleOptions = clientTypes.size() != 1;
        }
    }

    private static ClientType[] getClientManifest() throws IOException {
        URL u = new URL(LauncherProperties.getRuneliteTypeManifest());
        URLConnection conn = u.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        try (InputStream i = conn.getInputStream();){
            byte[] bytes = ByteStreams.toByteArray(i);
            Gson g = new Gson();
            ClientType[] clientTypeArray = g.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)), ClientType[].class);
            return clientTypeArray;
        }
    }

    private static Bootstrap getBootstrap(String type) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, VerificationException {
        URL u = new URL(clientTypes.get(type).getBootstrap());
        URL signatureUrl = new URL(clientTypes.get(type).getBootstrapsig());
        URLConnection conn = u.openConnection();
        URLConnection signatureConn = signatureUrl.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        signatureConn.setRequestProperty("User-Agent", USER_AGENT);
        try (InputStream i = conn.getInputStream();){
            Bootstrap bootstrap;
            block13: {
                InputStream signatureIn = signatureConn.getInputStream();
                try {
                    byte[] bytes = ByteStreams.toByteArray(i);
                    byte[] signature = ByteStreams.toByteArray(signatureIn);
                    Certificate certificate = Launcher.getCertificate();
                    Signature s = Signature.getInstance("SHA256withRSA");
                    s.initVerify(certificate);
                    s.update(bytes);
                    if (!s.verify(signature)) {
                        throw new VerificationException("Unable to verify bootstrap signature: " + type);
                    }
                    Gson g = new Gson();
                    bootstrap = g.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)), Bootstrap.class);
                    if (signatureIn == null) break block13;
                }
                catch (Throwable throwable) {
                    if (signatureIn != null) {
                        try {
                            signatureIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                signatureIn.close();
            }
            return bootstrap;
        }
    }

    private static boolean jvmOutdated(Bootstrap bootstrap) {
        boolean launcherTooOld = bootstrap.getRequiredLauncherVersion() != null && Launcher.compareVersion(bootstrap.getRequiredLauncherVersion(), LauncherProperties.getVersion()) > 0;
        boolean jvmTooOld = false;
        try {
            if (bootstrap.getRequiredJVMVersion() != null) {
                jvmTooOld = Runtime.Version.parse(bootstrap.getRequiredJVMVersion()).compareTo(Runtime.version()) > 0;
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Unable to parse bootstrap version", e);
        }
        if (launcherTooOld) {
            SwingUtilities.invokeLater(() -> new FatalErrorDialog("Your launcher is too old to start {name}. Please download and install a more recent one from {link}.").addButton("{link}", () -> LinkBrowser.browse(LauncherProperties.getDownloadLink())).open());
            return true;
        }
        if (jvmTooOld) {
            SwingUtilities.invokeLater(() -> new FatalErrorDialog("Your Java installation is too old. {name} now requires Java " + bootstrap.getRequiredJVMVersion() + " to run. You can get a platform specific version from {link}, or install a newer version of Java.").addButton("{link}", () -> LinkBrowser.browse(LauncherProperties.getDownloadLink())).open());
            return true;
        }
        return false;
    }

    private static Collection<String> getClientArgs(LauncherSettings settings) {
        ArrayList<String> args = new ArrayList<String>(settings.clientArguments);
        String clientArgs = System.getenv(LauncherProperties.getApplicationName().toUpperCase() + "_ARGS");
        if (!Strings.isNullOrEmpty(clientArgs)) {
            args.addAll(Splitter.on(' ').omitEmptyStrings().trimResults().splitToList(clientArgs));
        }
        if (settings.debug) {
            args.add("--debug");
        }
        if (settings.safemode) {
            args.add("--safe-mode");
        }
        return args;
    }

    private static List<String> getJvmArgs(LauncherSettings settings) {
        ArrayList<String> args = new ArrayList<String>(settings.jvmArguments);
        String envArgs = System.getenv(LauncherProperties.getApplicationName().toUpperCase() + "_VMARGS");
        if (!Strings.isNullOrEmpty(envArgs)) {
            args.addAll(Splitter.on(' ').omitEmptyStrings().trimResults().splitToList(envArgs));
        }
        return args;
    }

    private static void download(List<Artifact> artifacts, boolean nodiff, String type) throws IOException {
        File location = new File(RUNELITE_DIR, "repository/" + type + "/");
        ArrayList<Artifact> toDownload = new ArrayList<Artifact>(artifacts.size());
        HashMap<Artifact, Diff> diffs = new HashMap<Artifact, Diff>();
        int totalDownloadBytes = 0;
        boolean isCompatible = new DefaultDeflateCompatibilityWindow().isCompatible();
        if (!isCompatible && !nodiff) {
            log.debug("System zlib is not compatible with archive-patcher; not using diffs");
            nodiff = true;
        }
        for (Artifact artifact : artifacts) {
            String hash;
            File dest = new File(location, artifact.getName());
            try {
                hash = Launcher.hash(dest);
            }
            catch (FileNotFoundException ex) {
                hash = null;
            }
            if (Objects.equals(artifact.getName(), "gameNonObfuscated-0.0.1.jar") || Objects.equals(artifact.getPath(), "https://repo.maven.apache.org/maven2/com/client/game/0.0.1/game-0.0.1.jar")) continue;
            if (Objects.equals(hash, artifact.getHash())) {
                log.debug("Hash for {} up to date", (Object)artifact.getName());
                continue;
            }
            int downloadSize = artifact.getSize();
            if (!nodiff && artifact.getDiffs() != null) {
                for (Diff diff : artifact.getDiffs()) {
                    String oldhash;
                    File old = new File(location, diff.getFrom());
                    try {
                        oldhash = Launcher.hash(old);
                    }
                    catch (FileNotFoundException ex) {
                        oldhash = null;
                    }
                    if (!diff.getFromHash().equals(oldhash)) continue;
                    diffs.put(artifact, diff);
                    downloadSize = diff.getSize();
                }
            }
            toDownload.add(artifact);
            totalDownloadBytes += downloadSize;
        }
        double START_PROGRESS = 0.15;
        int downloaded = 0;
        Launcher.stage(0.15, "Downloading", "");
        for (Artifact artifact : toDownload) {
            File dest = new File(location, artifact.getName());
            int total = downloaded;
            Diff diff = (Diff)diffs.get(artifact);
            if (diff != null) {
                log.debug("Downloading diff {}", (Object)diff.getName());
                try {
                    HashCode hash;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int totalBytes = totalDownloadBytes;
                    Launcher.download(diff.getPath(), diff.getHash(), completed -> Launcher.stage(0.15, 0.8, null, diff.getName(), total + completed, totalBytes, true), out);
                    downloaded += diff.getSize();
                    File old = new File(location, diff.getFrom());
                    try (GZIPInputStream patchStream = new GZIPInputStream(new ByteArrayInputStream(out.toByteArray()));
                         HashingOutputStream fout = new HashingOutputStream(Hashing.sha256(), Files.newOutputStream(dest.toPath(), new OpenOption[0]));){
                        new FileByFileV1DeltaApplier().applyDelta(old, patchStream, fout);
                        hash = fout.hash();
                    }
                    if (artifact.getHash().equals(hash.toString())) {
                        log.debug("Patching successful for {}", (Object)artifact.getName());
                        continue;
                    }
                    log.debug("Patched artifact hash mismatches! {}: got {} expected {}", artifact.getName(), hash.toString(), artifact.getHash());
                }
                catch (IOException | VerificationException e) {
                    log.warn("unable to download patch {}", (Object)diff.getName(), (Object)e);
                }
                totalDownloadBytes -= diff.getSize();
                totalDownloadBytes += artifact.getSize();
            }
            log.debug("Downloading {}", (Object)artifact.getName());
            try {
                OutputStream fout = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                try {
                    int totalBytes = totalDownloadBytes;
                    Launcher.download(artifact.getPath(), artifact.getHash(), completed -> Launcher.stage(0.15, 0.8, null, artifact.getName(), total + completed, totalBytes, true), fout);
                    downloaded += artifact.getSize();
                }
                finally {
                    if (fout == null) continue;
                    fout.close();
                }
            }
            catch (VerificationException e) {
                log.warn("unable to verify jar {}", (Object)artifact.getName(), (Object)e);
            }
        }
    }

    private static void clean(List<Artifact> artifacts, String type) {
        File location = new File(RUNELITE_DIR, "repository/" + type + "/");
        File[] existingFiles = location.listFiles();
        if (existingFiles == null) {
            return;
        }
        HashSet<String> artifactNames = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            artifactNames.add(artifact.getName());
            if (artifact.getDiffs() == null) continue;
            for (Diff diff : artifact.getDiffs()) {
                artifactNames.add(diff.getFrom());
            }
        }
        for (File file : existingFiles) {
            if (!file.isFile() || artifactNames.contains(file.getName())) continue;
            if (file.delete()) {
                log.debug("Deleted old artifact {}", (Object)file);
                continue;
            }
            log.warn("Unable to delete old artifact {}", (Object)file);
        }
    }

    private static void verifyJarHashes(List<Artifact> artifacts, String type) throws VerificationException {
        File location = new File(RUNELITE_DIR, "repository/" + type + "/");
        for (Artifact artifact : artifacts) {
            String fileHash;
            String expectedHash = artifact.getHash();
            try {
                fileHash = Launcher.hash(new File(location, artifact.getName()));
            }
            catch (IOException e) {
                throw new VerificationException("unable to hash file", e);
            }
            if (!fileHash.equals(expectedHash)) {
                log.warn("Expected {} for {} but got {}", expectedHash, artifact.getName(), fileHash);
                throw new VerificationException("Expected " + expectedHash + " for " + artifact.getName() + " but got " + fileHash);
            }
            log.info("Verified hash of {}", (Object)artifact.getName());
        }
    }

    private static String hash(File file) throws IOException {
        HashFunction sha256 = Hashing.sha256();
        return com.google.common.io.Files.asByteSource(file).hash(sha256).toString();
    }

    private static Certificate getCertificate() throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certFactory.generateCertificate(Launcher.class.getResourceAsStream("launcher.crt"));
        return certificate;
    }

    static int compareVersion(String a, String b) {
        Pattern tok = Pattern.compile("[^0-9a-zA-Z]");
        return Arrays.compare(tok.split(a), tok.split(b), (x, y) -> {
            Integer ix = null;
            try {
                ix = Integer.parseInt(x);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Integer iy = null;
            try {
                iy = Integer.parseInt(y);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ix == null && iy == null) {
                return x.compareToIgnoreCase((String)y);
            }
            if (ix == null) {
                return -1;
            }
            if (iy == null) {
                return 1;
            }
            if (ix > iy) {
                return 1;
            }
            if (ix < iy) {
                return -1;
            }
            return 0;
        });
    }

    static void download(String path, String hash, IntConsumer progress, OutputStream out) throws IOException, VerificationException {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        conn.getResponseCode();
        InputStream err = conn.getErrorStream();
        if (err != null) {
            err.close();
            throw new IOException("Unable to download " + path + " - " + conn.getResponseMessage());
        }
        int downloaded = 0;
        HashingOutputStream hout = new HashingOutputStream(Hashing.sha256(), out);
        try (InputStream in = conn.getInputStream();){
            int i;
            byte[] buffer = new byte[0x100000];
            while ((i = in.read(buffer)) != -1) {
                hout.write(buffer, 0, i);
                progress.accept(downloaded += i);
            }
        }
        HashCode hashCode = hout.hash();
        if (!hash.equals(hashCode.toString())) {
            throw new VerificationException("Unable to verify resource " + path + " - expected " + hash + " got " + hashCode.toString());
        }
    }

    static boolean isJava17() {
        return Runtime.version().feature() >= 16;
    }

    private static void postInstall(String type) {
        Bootstrap bootstrap;
        try {
            bootstrap = Launcher.getBootstrap(type);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | VerificationException ex) {
            log.error("error fetching bootstrap", ex);
            return;
        }
        PackrConfig.updateLauncherArgs(bootstrap);
        log.info("Performed postinstall steps");
    }

    private static void initDll() {
        if (OS.getOs() != OS.OSType.Windows) {
            return;
        }
        String arch = System.getProperty("os.arch");
        if (!Set.of("x86", "amd64", "aarch64").contains(arch)) {
            log.debug("System architecture is not supported for launcher natives: {}", (Object)arch);
            return;
        }
        try {
            System.loadLibrary("launcher_" + arch);
            log.debug("Loaded launcher native launcher_{}", (Object)arch);
        }
        catch (Error ex) {
            log.debug("Error loading launcher native", ex);
        }
    }

    private static void initDllBlacklist() {
        String blacklistedDlls = System.getProperty("runelite.launcher.blacklistedDlls");
        if (blacklistedDlls == null || blacklistedDlls.isEmpty()) {
            return;
        }
        String[] dlls = blacklistedDlls.split(",");
        try {
            log.debug("Setting blacklisted dlls: {}", (Object)blacklistedDlls);
            Launcher.setBlacklistedDlls(dlls);
        }
        catch (UnsatisfiedLinkError ex) {
            log.debug("Error setting dll blacklist", ex);
        }
    }

    private static native void setBlacklistedDlls(String[] var0);

    static native String regQueryString(String var0, String var1);

    public static void stage(double startProgress, double endProgress, @Nullable String actionText, String subActionText, int done, int total, boolean mib) {
        if (displayMultipleOptions) {
            SplashScreenMultipleOptions.stage(startProgress, endProgress, subActionText, done, total, mib);
        } else {
            SplashScreen.stage(startProgress, endProgress, actionText, subActionText, done, total, mib);
        }
    }

    public static void stage(double overallProgress, @Nullable String actionText, String subActionText) {
        if (displayMultipleOptions) {
            SplashScreenMultipleOptions.stage(overallProgress, subActionText);
        } else {
            SplashScreen.stage(overallProgress, actionText, subActionText);
        }
    }

    public static void close() {
        if (displayMultipleOptions) {
            SplashScreenMultipleOptions.close();
        } else {
            SplashScreen.stop();
        }
    }
}

